/*
 * Decompiled with CFR 0.152.
 */
package necesse.engine.world.worldPresets;

import necesse.engine.util.GameRandom;
import necesse.engine.util.LevelIdentifier;
import necesse.engine.world.biomeGenerator.BiomeGeneratorStack;
import necesse.engine.world.worldPresets.LevelPresetsRegion;
import necesse.engine.world.worldPresets.SimpleGenerationPreset;
import necesse.engine.world.worldPresets.WorldApplyAreaPredicate;
import necesse.engine.world.worldPresets.WorldPreset;
import necesse.engine.world.worldPresets.WorldPresetTester;
import necesse.level.maps.biomes.Biome;
import necesse.level.maps.presets.DavesPlantHousePreset;
import necesse.level.maps.presets.Preset;
import necesse.level.maps.presets.set.CropSet;
import necesse.level.maps.presets.set.GroundSet;
import necesse.level.maps.presets.set.PresetSet;
import necesse.level.maps.presets.set.TreeSet;

public class DavesPlantHouseGenerationPreset
extends SimpleGenerationPreset {
    public final Biome biome;
    public final LevelIdentifier levelIdentifier;
    public final GroundSet[] ground;
    public final TreeSet[] tree;
    public final CropSet[] corn;

    public DavesPlantHouseGenerationPreset(LevelIdentifier levelIdentifier, Biome biome) {
        super(20, false, false, false, false, biome);
        this.biome = biome;
        this.levelIdentifier = levelIdentifier;
        this.ground = (GroundSet[])GroundSet.getReducedSetForBiome((PresetSet[])new GroundSet[]{GroundSet.forest, GroundSet.plains, GroundSet.swamp}, (Biome)biome, (LevelIdentifier)levelIdentifier, (PresetSet[])new GroundSet[0]);
        this.tree = (TreeSet[])TreeSet.getReducedSetForBiome((PresetSet[])new TreeSet[]{TreeSet.willow, TreeSet.oak, TreeSet.maple}, (Biome)biome, (LevelIdentifier)levelIdentifier, (PresetSet[])new TreeSet[0]);
        this.corn = (CropSet[])CropSet.getReducedSetForBiome((PresetSet[])new CropSet[]{CropSet.cabbage, CropSet.corn}, (Biome)biome, (LevelIdentifier)levelIdentifier, (PresetSet[])new CropSet[0]);
    }

    @Override
    public void setupTester(WorldPresetTester tester) {
        tester.addApplyPredicate(new WorldApplyAreaPredicate(0, 0, tester.width - 1, tester.height - 1, 0, new WorldApplyAreaPredicate.WorldApplyCornerTest(){

            @Override
            public boolean isValidTile(WorldPreset preset, LevelPresetsRegion presetsRegion, BiomeGeneratorStack generatorStack, int tileX, int tileY) {
                if (presetsRegion.identifier.equals(LevelIdentifier.SURFACE_IDENTIFIER)) {
                    return !generatorStack.isSurfaceOceanOrRiver(tileX, tileY);
                }
                if (presetsRegion.identifier.equals(LevelIdentifier.CAVE_IDENTIFIER)) {
                    return !generatorStack.isCaveRiverOrLava(tileX, tileY);
                }
                if (presetsRegion.identifier.equals(LevelIdentifier.DEEP_CAVE_IDENTIFIER)) {
                    return !generatorStack.isDeepCaveLava(tileX, tileY);
                }
                return false;
            }
        }));
    }

    @Override
    public Preset getPreset(GameRandom random) {
        return new DavesPlantHousePreset(this.biome, this.levelIdentifier, random, random.getOneOf(this.ground), random.getOneOf(this.tree), random.getOneOf(this.corn));
    }
}

