/*
 * Decompiled with CFR 0.152.
 */
package necesse.engine.network.server;

import java.io.IOException;
import necesse.engine.gameLoop.tickManager.Performance;
import necesse.engine.gameLoop.tickManager.PerformanceTimerManager;
import necesse.engine.gameLoop.tickManager.PerformanceWrapper;

public abstract class AbstractSaveHandler {
    public final PerformanceTimerManager performanceTimer;
    public final String debugName;

    public AbstractSaveHandler(PerformanceTimerManager performanceTimer, String debugName) {
        this.performanceTimer = performanceTimer;
        this.debugName = debugName;
    }

    protected abstract boolean tickInternal() throws IOException;

    public final boolean tick() throws IOException {
        if (this.debugName != null) {
            PerformanceWrapper wrapper = Performance.wrapTimer(this.performanceTimer, this.debugName);
            try {
                boolean bl = this.tickInternal();
                return bl;
            }
            finally {
                wrapper.end();
            }
        }
        return this.tickInternal();
    }
}

