/*
 * Decompiled with CFR 0.152.
 */
package necesse.engine.window;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import necesse.engine.window.WindowManager;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GameWindowIcon {
    public final int width;
    public final int height;
    private final byte[] data;

    /*
     * Opcode count of 16393 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static GameWindowIcon getIcon() {
        return new GameWindowIcon(32, 32, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 76, 32, 11, 0, 76, 32, 11, 0, 63, 28, 3, -1, 63, 28, 3, -1, 82, 38, 6, -1, 82, 38, 6, -1, 63, 28, 3, -1, 63, 28, 3, -1, 123, 57, 10, -1, 123, 57, 10, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, -118, 111, 48, -1, -118, 111, 48, -1, -100, 125, 51, -1, -100, 125, 51, -1, -118, 111, 48, -1, -118, 111, 48, -1, 113, 89, 34, -1, 113, 89, 34, -1, 63, 28, 3, -1, 63, 28, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 76, 32, 11, 0, 76, 32, 11, 0, 63, 28, 3, -1, 63, 28, 3, -1, 82, 38, 6, -1, 82, 38, 6, -1, 63, 28, 3, -1, 63, 28, 3, -1, 123, 57, 10, -1, 123, 57, 10, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, -118, 111, 48, -1, -118, 111, 48, -1, -100, 125, 51, -1, -100, 125, 51, -1, -118, 111, 48, -1, -118, 111, 48, -1, 113, 89, 34, -1, 113, 89, 34, -1, 63, 28, 3, -1, 63, 28, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 65, 22, 22, -1, 65, 22, 22, -1, 102, 47, 8, -1, 102, 47, 8, -1, 65, 22, 22, -1, 65, 22, 22, -1, 63, 28, 3, -1, 63, 28, 3, -1, 65, 22, 22, -1, 65, 22, 22, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, -118, 111, 48, -1, -118, 111, 48, -1, 113, 89, 34, -1, 113, 89, 34, -1, 82, 38, 6, -1, 82, 38, 6, -1, 102, 47, 8, -1, 102, 47, 8, -1, 0, 0, 0, 0, 0, 0, 0, 0, 65, 22, 22, -1, 65, 22, 22, -1, 102, 47, 8, -1, 102, 47, 8, -1, 65, 22, 22, -1, 65, 22, 22, -1, 63, 28, 3, -1, 63, 28, 3, -1, 65, 22, 22, -1, 65, 22, 22, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, -118, 111, 48, -1, -118, 111, 48, -1, 113, 89, 34, -1, 113, 89, 34, -1, 82, 38, 6, -1, 82, 38, 6, -1, 102, 47, 8, -1, 102, 47, 8, -1, 65, 22, 22, -1, 65, 22, 22, -1, -52, 111, 99, -1, -52, 111, 99, -1, 65, 22, 22, -1, 65, 22, 22, -1, -52, 111, 99, -1, -52, 111, 99, -1, 65, 22, 22, -1, 65, 22, 22, -1, -52, 111, 99, -1, -52, 111, 99, -1, 65, 22, 22, -1, 65, 22, 22, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 113, 89, 34, -1, 113, 89, 34, -1, 63, 28, 3, -1, 63, 28, 3, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 65, 22, 22, -1, 65, 22, 22, -1, -52, 111, 99, -1, -52, 111, 99, -1, 65, 22, 22, -1, 65, 22, 22, -1, -52, 111, 99, -1, -52, 111, 99, -1, 65, 22, 22, -1, 65, 22, 22, -1, -52, 111, 99, -1, -52, 111, 99, -1, 65, 22, 22, -1, 65, 22, 22, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 113, 89, 34, -1, 113, 89, 34, -1, 63, 28, 3, -1, 63, 28, 3, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 63, 28, 3, -1, 63, 28, 3, -1, 113, 89, 34, -1, 113, 89, 34, -1, 102, 47, 8, -1, 102, 47, 8, -1, 123, 57, 10, -1, 123, 57, 10, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 63, 28, 3, -1, 63, 28, 3, -1, 113, 89, 34, -1, 113, 89, 34, -1, 102, 47, 8, -1, 102, 47, 8, -1, 123, 57, 10, -1, 123, 57, 10, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 123, 57, 10, -1, 123, 57, 10, -1, 82, 38, 6, -1, 82, 38, 6, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 63, 28, 3, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 123, 57, 10, -1, 123, 57, 10, -1, 82, 38, 6, -1, 82, 38, 6, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 123, 57, 10, -1, 123, 57, 10, -1, 82, 38, 6, -1, 82, 38, 6, -1, 63, 28, 3, -1, 63, 28, 3, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 123, 57, 10, -1, 123, 57, 10, -1, 82, 38, 6, -1, 82, 38, 6, -1, 63, 28, 3, -1, 63, 28, 3, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 82, 38, 6, -1, 82, 38, 6, -1, 63, 28, 3, -1, 63, 28, 3, -1, 107, 62, 35, 0, 107, 62, 35, 0, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 102, 47, 8, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 82, 38, 6, -1, 82, 38, 6, -1, 63, 28, 3, -1, 63, 28, 3, -1, 107, 62, 35, 0, 107, 62, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, -95, 83, 42, -1, -95, 83, 42, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, 82, 38, 6, -1, 82, 38, 6, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, -82, 107, 96, -1, -82, 107, 96, -1, -13, -69, -116, -1, -13, -69, -116, -1, 87, 29, 23, -1, 87, 29, 23, -1, 0, 0, 0, 0, 0, 0, 0, 0, 65, 22, 22, -1, 65, 22, 22, -1, -95, 83, 42, -1, -95, 83, 42, -1, -95, 83, 42, -1, -95, 83, 42, -1, -95, 83, 42, -1, -95, 83, 42, -1, 65, 22, 22, -1, 65, 22, 22, -1, 82, 38, 6, -1, 82, 38, 6, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 123, 57, 10, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, -82, 107, 96, -1, -82, 107, 96, -1, -13, -69, -116, -1, -13, -69, -116, -1, 87, 29, 23, -1, 87, 29, 23, -1, 0, 0, 0, 0, 0, 0, 0, 0, 79, 41, 24, 0, 79, 41, 24, 0, 45, 30, 17, -1, 45, 30, 17, -1, 103, 69, 38, -1, 103, 69, 38, -1, 45, 30, 17, -1, 45, 30, 17, -1, 43, 5, 0, -1, 43, 5, 0, -1, -1, -55, -101, -1, -1, -55, -101, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, -1, -55, -101, -1, -1, -55, -101, -1, 43, 5, 0, -1, 43, 5, 0, -1, -82, 107, 96, -1, -82, 107, 96, -1, -28, -90, 114, -1, -28, -90, 114, -1, 87, 29, 23, -1, 87, 29, 23, -1, 0, 0, 0, 0, 0, 0, 0, 0, 79, 41, 24, 0, 79, 41, 24, 0, 45, 30, 17, -1, 45, 30, 17, -1, 103, 69, 38, -1, 103, 69, 38, -1, 45, 30, 17, -1, 45, 30, 17, -1, 43, 5, 0, -1, 43, 5, 0, -1, -1, -55, -101, -1, -1, -55, -101, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, 82, 38, 6, -1, -1, -55, -101, -1, -1, -55, -101, -1, 43, 5, 0, -1, 43, 5, 0, -1, -82, 107, 96, -1, -82, 107, 96, -1, -28, -90, 114, -1, -28, -90, 114, -1, 87, 29, 23, -1, 87, 29, 23, -1, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 103, 69, 38, -1, 103, 69, 38, -1, 45, 30, 17, -1, 45, 30, 17, -1, -64, -80, -104, -1, -64, -80, -104, -1, 43, 5, 0, -1, 43, 5, 0, -1, 43, 5, 0, -1, 43, 5, 0, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, 43, 5, 0, -1, 43, 5, 0, -1, 43, 5, 0, -1, 43, 5, 0, -1, -64, -80, -104, -1, -64, -80, -104, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, 87, 29, 23, -1, 87, 29, 23, -1, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 103, 69, 38, -1, 103, 69, 38, -1, 45, 30, 17, -1, 45, 30, 17, -1, -64, -80, -104, -1, -64, -80, -104, -1, 43, 5, 0, -1, 43, 5, 0, -1, 43, 5, 0, -1, 43, 5, 0, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, 43, 5, 0, -1, 43, 5, 0, -1, 43, 5, 0, -1, 43, 5, 0, -1, -64, -80, -104, -1, -64, -80, -104, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, 87, 29, 23, -1, 87, 29, 23, -1, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 103, 69, 38, -1, 103, 69, 38, -1, 45, 30, 17, -1, 45, 30, 17, -1, -16, -16, -16, -1, -16, -16, -16, -1, 56, -105, -57, -1, 56, -105, -57, -1, -82, 107, 96, -1, -82, 107, 96, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -82, 107, 96, -1, -82, 107, 96, -1, 56, -105, -57, -1, 56, -105, -57, -1, -16, -16, -16, -1, -16, -16, -16, -1, -82, 107, 96, -1, -82, 107, 96, -1, 87, 29, 23, -1, 87, 29, 23, -1, 116, 55, 47, 0, 116, 55, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 103, 69, 38, -1, 103, 69, 38, -1, 45, 30, 17, -1, 45, 30, 17, -1, -16, -16, -16, -1, -16, -16, -16, -1, 56, -105, -57, -1, 56, -105, -57, -1, -82, 107, 96, -1, -82, 107, 96, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -82, 107, 96, -1, -82, 107, 96, -1, 56, -105, -57, -1, 56, -105, -57, -1, -16, -16, -16, -1, -16, -16, -16, -1, -82, 107, 96, -1, -82, 107, 96, -1, 87, 29, 23, -1, 87, 29, 23, -1, 116, 55, 47, 0, 116, 55, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 90, 60, 34, -1, 90, 60, 34, -1, 45, 30, 17, -1, 45, 30, 17, -1, -16, -16, -16, -1, -16, -16, -16, -1, 56, -105, -57, -1, 56, -105, -57, -1, -82, 107, 96, -1, -82, 107, 96, -1, -13, -69, -116, -1, -13, -69, -116, -1, -13, -69, -116, -1, -13, -69, -116, -1, -82, 107, 96, -1, -82, 107, 96, -1, 56, -105, -57, -1, 56, -105, -57, -1, -16, -16, -16, -1, -16, -16, -16, -1, 87, 29, 23, -1, 87, 29, 23, -1, 108, 48, 41, 0, 108, 48, 41, 0, 87, 29, 23, 0, 87, 29, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 90, 60, 34, -1, 90, 60, 34, -1, 45, 30, 17, -1, 45, 30, 17, -1, -16, -16, -16, -1, -16, -16, -16, -1, 56, -105, -57, -1, 56, -105, -57, -1, -82, 107, 96, -1, -82, 107, 96, -1, -13, -69, -116, -1, -13, -69, -116, -1, -13, -69, -116, -1, -13, -69, -116, -1, -82, 107, 96, -1, -82, 107, 96, -1, 56, -105, -57, -1, 56, -105, -57, -1, -16, -16, -16, -1, -16, -16, -16, -1, 87, 29, 23, -1, 87, 29, 23, -1, 108, 48, 41, 0, 108, 48, 41, 0, 87, 29, 23, 0, 87, 29, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 90, 60, 34, -1, 90, 60, 34, -1, 45, 30, 17, -1, 45, 30, 17, -1, -82, 107, 96, -1, -82, 107, 96, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -82, 107, 96, -1, -82, 107, 96, -1, 87, 29, 23, -1, 87, 29, 23, -1, 87, 29, 23, 0, 87, 29, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 90, 60, 34, -1, 90, 60, 34, -1, 45, 30, 17, -1, 45, 30, 17, -1, -82, 107, 96, -1, -82, 107, 96, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -82, 107, 96, -1, -82, 107, 96, -1, 87, 29, 23, -1, 87, 29, 23, -1, 87, 29, 23, 0, 87, 29, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 90, 60, 34, -1, 90, 60, 34, -1, 45, 30, 17, -1, 45, 30, 17, -1, 87, 29, 23, -1, 87, 29, 23, -1, -82, 107, 96, -1, -82, 107, 96, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -82, 107, 96, -1, -82, 107, 96, -1, 87, 29, 23, -1, 87, 29, 23, -1, 93, 61, 39, 0, 93, 61, 39, 0, 62, 37, 20, 0, 62, 37, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 90, 60, 34, -1, 90, 60, 34, -1, 45, 30, 17, -1, 45, 30, 17, -1, 87, 29, 23, -1, 87, 29, 23, -1, -82, 107, 96, -1, -82, 107, 96, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -28, -90, 114, -1, -82, 107, 96, -1, -82, 107, 96, -1, 87, 29, 23, -1, 87, 29, 23, -1, 93, 61, 39, 0, 93, 61, 39, 0, 62, 37, 20, 0, 62, 37, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 90, 60, 34, -1, 90, 60, 34, -1, 45, 30, 17, -1, 45, 30, 17, -1, 79, 96, 37, -1, 79, 96, 37, -1, 60, 72, 27, -1, 60, 72, 27, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, 60, 72, 27, -1, 60, 72, 27, -1, 79, 96, 37, -1, 79, 96, 37, -1, 38, 46, 18, -1, 38, 46, 18, -1, 54, 40, 19, 0, 54, 40, 19, 0, 87, 29, 23, 0, 87, 29, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 90, 60, 34, -1, 90, 60, 34, -1, 45, 30, 17, -1, 45, 30, 17, -1, 79, 96, 37, -1, 79, 96, 37, -1, 60, 72, 27, -1, 60, 72, 27, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, -82, 107, 96, -1, 60, 72, 27, -1, 60, 72, 27, -1, 79, 96, 37, -1, 79, 96, 37, -1, 38, 46, 18, -1, 38, 46, 18, -1, 54, 40, 19, 0, 54, 40, 19, 0, 87, 29, 23, 0, 87, 29, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 73, 49, 27, -1, 73, 49, 27, -1, 45, 30, 17, -1, 45, 30, 17, -1, 60, 72, 27, -1, 60, 72, 27, -1, 79, 96, 37, -1, 79, 96, 37, -1, 96, 73, 58, -1, 96, 73, 58, -1, 79, 96, 37, -1, 79, 96, 37, -1, 79, 96, 37, -1, 79, 96, 37, -1, 96, 73, 58, -1, 96, 73, 58, -1, 79, 96, 37, -1, 79, 96, 37, -1, 60, 72, 27, -1, 60, 72, 27, -1, 38, 46, 18, -1, 38, 46, 18, -1, 87, 29, 23, -1, 87, 29, 23, -1, 87, 29, 23, 0, 87, 29, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 30, 17, 0, 45, 30, 17, 0, 45, 30, 17, -1, 45, 30, 17, -1, 73, 49, 27, -1, 73, 49, 27, -1, 45, 30, 17, -1, 45, 30, 17, -1, 60, 72, 27, -1, 60, 72, 27, -1, 79, 96, 37, -1, 79, 96, 37, -1, 96, 73, 58, -1, 96, 73, 58, -1, 79, 96, 37, -1, 79, 96, 37, -1, 79, 96, 37, -1, 79, 96, 37, -1, 96, 73, 58, -1, 96, 73, 58, -1, 79, 96, 37, -1, 79, 96, 37, -1, 60, 72, 27, -1, 60, 72, 27, -1, 38, 46, 18, -1, 38, 46, 18, -1, 87, 29, 23, -1, 87, 29, 23, -1, 87, 29, 23, 0, 87, 29, 23, 0});
    }

    public static void copyIconConstructor(String file) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer width = stack.mallocInt(1);
            IntBuffer height = stack.mallocInt(1);
            IntBuffer comp = stack.mallocInt(1);
            ByteBuffer icon = STBImage.stbi_load((CharSequence)file, (IntBuffer)width, (IntBuffer)height, (IntBuffer)comp, (int)4);
            GameWindowIcon.copyIconConstructor(icon, width.get(0), height.get(0));
            STBImage.stbi_image_free((ByteBuffer)icon);
        }
    }

    public static void copyIconConstructor(ByteBuffer buffer, int width, int height) {
        byte[] ar = new byte[buffer.capacity()];
        buffer.get(ar);
        StringBuilder str = new StringBuilder();
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                int index = (w + h * width) * 4;
                str.append(ar[index]).append(", ");
                str.append(ar[index + 1]).append(", ");
                str.append(ar[index + 2]).append(", ");
                str.append(ar[index + 3]).append(", ");
            }
            str.append("\n");
        }
        String imgData = str.substring(0, str.lastIndexOf(","));
        String constructor = "new GameWindowIcon(" + width + ", " + height + ", new byte[] {" + imgData + "});";
        WindowManager.getWindow().putClipboard(constructor);
        System.out.println("GameIcon constructor copied to clipboard");
    }

    public static ByteBuffer scaleIcon(GameWindowIcon icon, int resolution) {
        ByteBuffer input = MemoryUtil.memAlloc((int)icon.data.length);
        input.put(icon.data);
        input.position(0);
        ByteBuffer output = MemoryUtil.memAlloc((int)(resolution * resolution * 4));
        STBImageResize.stbir_resize_uint8((ByteBuffer)input, (int)icon.width, (int)icon.height, (int)0, (ByteBuffer)output, (int)resolution, (int)resolution, (int)0, (int)4);
        MemoryUtil.memFree((Buffer)input);
        return output;
    }

    private GameWindowIcon(int width, int height, byte[] imgData) {
        if (imgData.length != width * height * 4) {
            throw new IllegalArgumentException("Width and height did not match imgData size");
        }
        this.width = width;
        this.height = height;
        this.data = imgData;
    }
}

