/*
 * Decompiled with CFR 0.152.
 */
package necesse.engine.world.biomeGenerator.layers;

import necesse.engine.world.biomeGenerator.layers.GeneratorLayer;

public abstract class RandomReplaceGeneratorLayer
extends GeneratorLayer {
    protected float replaceChance;
    protected boolean returnParentIfNotReplaced = false;

    public RandomReplaceGeneratorLayer(int layerSeed, float replaceChance, boolean reducedCacheSize) {
        super(layerSeed, 0, reducedCacheSize);
        this.replaceChance = replaceChance;
    }

    @Override
    protected int sample(int x, int y) {
        if (this.getRandom(x, y).getChance(this.replaceChance) && this.shouldReplaceValue(x, y)) {
            return this.getPlaceValue(x, y);
        }
        if (this.returnParentIfNotReplaced) {
            return this.getParent(x, y);
        }
        return 0;
    }

    protected abstract boolean shouldReplaceValue(int var1, int var2);

    protected abstract int getPlaceValue(int var1, int var2);
}

