/*
 * Decompiled with CFR 0.152.
 */
package necesse.engine.network.server;

import java.util.ArrayList;
import necesse.engine.gameLoop.tickManager.PerformanceTimerManager;
import necesse.engine.network.server.ClientsSaveHandler;
import necesse.engine.network.server.SaveHandlerList;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.SingleSaveHandler;
import necesse.entity.manager.WorldSavedEntityComponent;
import necesse.level.maps.Level;
import necesse.level.maps.LevelSaveHandler;

public class ServerSaveHandler
extends SaveHandlerList {
    public static int saveClientsPerTick = 1;
    public static int regionsPerTick = 20;
    public ArrayList<SaveInterruptedOrFinishedEventHandler> saveEvents = new ArrayList();

    public ServerSaveHandler(PerformanceTimerManager performanceTimer, Server server) {
        super(performanceTimer, null, 10);
        this.addHandler(new SingleSaveHandler(performanceTimer, "worldData", () -> {
            server.world.saveWorldEntity();
            server.world.settings.saveSettings();
            server.world.worldEntity.dataComponentManager.streamAll(WorldSavedEntityComponent.class).forEach(WorldSavedEntityComponent::onWorldSaved);
        }));
        this.addHandler(new ClientsSaveHandler(performanceTimer, server));
        for (Level level : server.world.levelManager.getLoadedLevels()) {
            this.addHandler(new LevelSaveHandler(performanceTimer, server, level));
        }
    }

    public static interface SaveInterruptedOrFinishedEventHandler {
        default public void onSaveInterrupted(ServerSaveHandler newSaveHandler) {
        }

        default public void onSaveFinished() {
        }
    }
}

