/*
 * Decompiled with CFR 0.152.
 */
package necesse.entity.mobs.ai.behaviourTree.trees;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.function.Supplier;
import necesse.engine.network.packet.PacketMobAttack;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.gameAreaSearch.GameAreaStream;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.ai.behaviourTree.Blackboard;
import necesse.entity.mobs.ai.behaviourTree.composites.SelectorAINode;
import necesse.entity.mobs.ai.behaviourTree.event.ConfuseWanderAIEvent;
import necesse.entity.mobs.ai.behaviourTree.leaves.ConfusedWandererAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.WandererAINode;
import necesse.entity.mobs.ai.behaviourTree.trees.CollisionChaserAI;
import necesse.entity.mobs.ai.behaviourTree.util.TargetFinderDistance;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.hostile.ItemAttackerRaiderMob;
import necesse.entity.mobs.hostile.SharkMob;

public class SharkAI<T extends SharkMob>
extends SelectorAINode<T> {
    protected long lastCritterTargetTime = 0L;
    protected long critterAttackCooldown = 8000L;

    public SharkAI(int searchDistance) {
        this.addChild(new ConfusedWandererAINode());
        this.addChild(new CollisionChaserAI<T>(searchDistance, new GameDamage(24.0f), 5){

            @Override
            public void init(T mob, Blackboard<T> blackboard) {
                super.init(mob, blackboard);
                this.targetFinderAINode.canRegainSameTargetIfLostToTimer = false;
                this.targetFinderAINode.loseTargetMaxCooldown = 100;
                this.targetFinderAINode.loseTargetMinCooldown = 100;
            }

            @Override
            public GameAreaStream<Mob> streamPossibleTargets(T mob, Point base, TargetFinderDistance<T> distance) {
                return distance.streamMobsAndPlayersInRange(base, mob).filter(m -> {
                    if (m == mob) {
                        return false;
                    }
                    if (!SharkAI.this.mobIsInWater((Mob)m)) {
                        return false;
                    }
                    if (m.isPlayer) {
                        return true;
                    }
                    if (m.isCritter) {
                        return SharkAI.this.lastCritterTargetTime + SharkAI.this.critterAttackCooldown < m.getTime();
                    }
                    if (m instanceof ItemAttackerRaiderMob) {
                        return true;
                    }
                    if (m.isHuman) {
                        return false;
                    }
                    return false;
                });
            }

            @Override
            public boolean attackTarget(T mob, Mob target) {
                return SharkAI.this.sharkAttack(mob, target, () -> super.attackTarget(mob, target));
            }
        });
        this.addChild(new WandererAINode<T>(0){

            @Override
            public void init(T mob, Blackboard<T> blackboard) {
                super.init(mob, blackboard);
                this.searchRadius = 15;
            }
        });
    }

    protected boolean sharkAttack(T mob, Mob target, Supplier<Boolean> superAttackTarget) {
        boolean superAttck = superAttackTarget.get();
        if (superAttck) {
            if (target.isCritter) {
                this.lastCritterTargetTime = mob.getTime();
            } else {
                if ((float)target.getHealth() > 0.0f) {
                    target.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.SHARK_BLEED, target, 3.0f, (Attacker)mob), true);
                }
                ((Entity)mob).getServer().network.sendToAllClients(new PacketMobAttack((Mob)mob, ((Entity)mob).getX(), ((Entity)mob).getY(), true));
                Point2D.Float attackDir = GameMath.normalize(target.x - ((SharkMob)mob).x, target.y - ((SharkMob)mob).y);
                float attackAngle = GameMath.getAngle(attackDir);
                float runAwayAngle = GameMath.fixAngle(attackAngle + GameRandom.globalRandom.getFloatBetween(-20.0f, 20.0f));
                Point2D.Float runAwayDir = GameMath.getAngleDir(runAwayAngle);
                int confuseTime = GameRandom.globalRandom.getIntBetween(2000, 3000);
                this.getBlackboard().submitEvent("confuseWander", new ConfuseWanderAIEvent(confuseTime, runAwayDir));
            }
        }
        return superAttck;
    }

    protected boolean mobIsInWater(Mob targetMob) {
        if (targetMob == null) {
            return false;
        }
        if (targetMob.getLevel() == null) {
            return false;
        }
        return targetMob.getLevel().liquidManager.getHeight(targetMob.getTileX(), targetMob.getTileY()) < -3;
    }
}

