/*
 * Decompiled with CFR 0.152.
 */
package necesse.inventory.container.settlement.data;

import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.inventory.InventoryItem;
import necesse.inventory.container.settlement.data.SettlementSettlerData;
import necesse.inventory.item.ItemCategory;
import necesse.inventory.item.ItemSearchTester;
import necesse.inventory.itemFilter.ItemCategoriesFilter;
import necesse.level.maps.levelData.settlementData.LevelSettler;
import necesse.level.maps.levelData.settlementData.settler.SettlerMob;

public class SettlementSettlerEquipmentFilterData
extends SettlementSettlerData {
    public boolean preferArmorSets;
    public final ItemCategoriesFilter equipmentFilter = new ItemCategoriesFilter(ItemCategory.equipmentMasterCategory, true);

    public SettlementSettlerEquipmentFilterData(LevelSettler settler) {
        super(settler);
        this.preferArmorSets = settler.preferArmorSets;
        this.equipmentFilter.loadFromCopy(settler.equipmentFilter);
    }

    public SettlementSettlerEquipmentFilterData(PacketReader reader) {
        super(reader);
        this.preferArmorSets = reader.getNextBoolean();
        this.equipmentFilter.readPacket(reader);
    }

    @Override
    public void writeContentPacket(PacketWriter writer) {
        super.writeContentPacket(writer);
        writer.putNextBoolean(this.preferArmorSets);
        this.equipmentFilter.writePacket(writer);
    }

    @Override
    protected boolean mobMatchesSearch(String lowerCaseSearchString, SettlerMob mob, PlayerMob perspective) {
        if (super.mobMatchesSearch(lowerCaseSearchString, mob, perspective)) {
            return true;
        }
        if (mob instanceof HumanMob) {
            HumanMob humanMob = (HumanMob)mob;
            ItemSearchTester tester = ItemSearchTester.constructSearchTester(lowerCaseSearchString);
            for (int slot = 0; slot < humanMob.equipmentInventory.getSize(); ++slot) {
                InventoryItem item = humanMob.equipmentInventory.getItem(slot);
                if (item == null || !tester.matches(item, perspective, new GameBlackboard())) continue;
                return true;
            }
        }
        return false;
    }
}

