/*
 * Decompiled with CFR 0.152.
 */
package necesse.entity.mobs.hostile;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.MobRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.SoundSettings;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.MobSpawnLocation;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.SharkAI;
import necesse.entity.mobs.ai.behaviourTree.util.AIMover;
import necesse.entity.mobs.hostile.HostileMob;
import necesse.entity.mobs.networkField.BooleanNetworkField;
import necesse.entity.mobs.summon.WoodBoatMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.ChanceLootItem;
import necesse.inventory.lootTable.lootItem.LootItem;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.TilePosition;
import necesse.level.maps.biomes.Biome;
import necesse.level.maps.light.GameLight;

public class SharkMob
extends HostileMob {
    protected double deltaCounter = 0.0;
    public BooleanNetworkField isChasing;
    protected int swimParticleOffset = 13;
    public static OneOfLootItems randomFishLoot = new OneOfLootItems(new ChanceLootItem(0.6f, "mackerel"), new ChanceLootItem(0.6f, "herring"), new ChanceLootItem(0.6f, "tuna"), new ChanceLootItem(0.6f, "salmon"), new ChanceLootItem(0.6f, "cod"));
    public static LootTable lootTable = new LootTable(randomMapDrop, randomFishLoot, new LootItem("sharkfin"), new ChanceLootItem(0.4f, "sharktooth"));

    public SharkMob() {
        super(500);
        this.setSpeed(30.0f);
        this.setSwimSpeed(1.0f);
        this.setFriction(1.0f);
        this.collision = new Rectangle(-16, -14, 32, 28);
        this.hitBox = new Rectangle(-20, -16, 40, 32);
        this.selectBox = new Rectangle(-20, -20, 40, 40);
        this.swimMaskMove = 0;
        this.swimMaskOffset = 0;
        this.swimSinkOffset = 0;
        this.isChasing = this.registerNetworkField(new BooleanNetworkField(false));
        this.setKnockbackModifier(0.5f);
        this.setTeam(-1);
    }

    @Override
    public LootTable getLootTable() {
        return lootTable;
    }

    @Override
    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI<SharkMob>(this, new SharkAI(640), new AIMover());
        this.updateSpeed();
    }

    @Override
    public float getFullInLiquidAtPercent(int x, int y) {
        return 0.4f;
    }

    @Override
    public void tickMovement(float delta) {
        super.tickMovement(delta);
        if (!this.isClient()) {
            return;
        }
        if (this.dx == 0.0f && this.dy == 0.0f) {
            return;
        }
        this.deltaCounter += (double)(delta * Math.max(0.2f, this.getCurrentSpeed() / 30.0f));
        if (this.deltaCounter >= 50.0) {
            this.deltaCounter -= 50.0;
            WoodBoatMob.addParticleEffects(this, 0.0f, 0.0f, this.swimParticleOffset);
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        this.updateSpeed();
    }

    @Override
    public void serverTick() {
        super.serverTick();
        Object chaserTarget = this.ai.blackboard.get("chaserTarget");
        this.isChasing.set(chaserTarget != null);
        this.updateSpeed();
    }

    public void updateSpeed() {
        if (((Boolean)this.isChasing.get()).booleanValue()) {
            this.setSpeed(65.0f);
        } else {
            this.setSpeed(30.0f);
        }
    }

    @Override
    public boolean isValidSpawnLocation(Server server, ServerClient client, int targetX, int targetY) {
        return new MobSpawnLocation(this, targetX, targetY).checkMobSpawnLocation().checkInLiquid().checkMaxMobsAround(1, Mob.MOB_SPAWN_AREA.maxSpawnDistance * 3, m -> m instanceof SharkMob, client).validAndApply();
    }

    @Override
    public MobSpawnLocation checkSpawnLocation(MobSpawnLocation location) {
        return location.checkNotLevelCollides().checkTile((tileX, tileY) -> this.getLevel().liquidManager.getTileMobHeightPercent(null, (int)tileX, (int)tileY) > 0.8f);
    }

    @Override
    public void showAttack(int x, int y, int seed, boolean showAllDirections) {
        super.showAttack(x, y, seed, showAllDirections);
        if (this.isClient()) {
            SoundManager.playSound(new SoundSettings(GameResources.sharkAttack).volume(0.4f), this);
        }
    }

    @Override
    public void updateAttackDir(int x, int y, boolean showAllDirections) {
    }

    @Override
    public CollisionFilter getLevelCollisionFilter() {
        return super.getLevelCollisionFilter().allLandTiles();
    }

    @Override
    public boolean estimateCanMoveTo(int tileX, int tileY, boolean acceptAdjacentTile) {
        if (!this.getLevel().isLiquidTile(tileX, tileY)) {
            return false;
        }
        return super.estimateCanMoveTo(tileX, tileY, acceptAdjacentTile);
    }

    @Override
    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 3; ++i) {
            this.getLevel().entityManager.addParticle(new FleshParticle(this.getLevel(), MobRegistry.Textures.shark, i, 12, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    @Override
    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(SharkMob.getTileCoordinate(x), SharkMob.getTileCoordinate(y));
        int drawX = camera.getDrawX(x) - 48;
        int drawY = camera.getDrawY(y) - 48;
        Point sprite = this.getAnimSprite(x, y, this.getDir());
        final TextureDrawOptionsEnd options = this.getSharkTexture().initDraw().sprite(sprite.x, sprite.y, 96).light(light).pos(drawX, drawY);
        list.add(new MobDrawable(){

            @Override
            public void draw(TickManager tickManager) {
                options.draw();
            }
        });
    }

    protected GameTexture getSharkTexture() {
        return MobRegistry.Textures.shark;
    }

    @Override
    protected TextureDrawOptions getShadowDrawOptions(Level level, int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = MobRegistry.Textures.human_baby_shadow;
        int res = shadowTexture.getHeight();
        int drawX = camera.getDrawX(x) - res / 2;
        int drawY = camera.getDrawY(y) - res / 2;
        return shadowTexture.initDraw().sprite(this.getDir(), 0, res).light(light).pos(drawX, drawY += this.getBobbing(x, y));
    }

    @Override
    public Point getAnimSprite(int x, int y, int dir) {
        Point p = new Point(0, dir);
        p.x = Math.abs(this.dx) <= 0.01f && Math.abs(this.dy) <= 0.01f ? 0 : (int)(this.getDistanceRan() / (double)this.getRockSpeed()) % 4 + 1;
        return p;
    }

    @Override
    public int getRockSpeed() {
        return 14;
    }

    @Override
    public int getTileWanderPriority(TilePosition pos, Biome baseBiome) {
        if (pos.tileID() == TileRegistry.waterID) {
            int height = pos.level.liquidManager.getHeight(pos.tileX, pos.tileY);
            if (height < -7) {
                return 1000;
            }
            return Math.abs(height) * 100;
        }
        return -1000;
    }

    @Override
    protected SoundSettings getHurtSound() {
        return new SoundSettings(GameResources.sharkHurt).volume(0.2f);
    }

    @Override
    protected SoundSettings getDeathSound() {
        return new SoundSettings(GameResources.sharkDeath).volume(0.7f);
    }
}

