/*
 * Decompiled with CFR 0.152.
 */
package necesse.entity.mobs.buffs.staticBuffs;

import java.awt.Point;
import java.util.concurrent.atomic.AtomicReference;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.HumanDrawBuff;
import necesse.entity.mobs.buffs.MovementTickBuff;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.particle.Particle;
import necesse.entity.particle.ParticleOption;
import necesse.gfx.GameResources;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.inventory.InventoryItem;

public class RingOfAscensionActiveBuff
extends Buff
implements MovementTickBuff,
HumanDrawBuff {
    public RingOfAscensionActiveBuff() {
        this.shouldSave = false;
        this.isVisible = false;
    }

    @Override
    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setMinModifier(BuffModifiers.SPEED_FLAT, Float.valueOf(150.0f));
        buff.setMinModifier(BuffModifiers.FRICTION, Float.valueOf(5.0f), Integer.MAX_VALUE);
        buff.setMinModifier(BuffModifiers.ACCELERATION, Float.valueOf(1.0f), Integer.MAX_VALUE);
        buff.setMinModifier(BuffModifiers.DECELERATION, Float.valueOf(1.0f), Integer.MAX_VALUE);
        buff.setMaxModifier(BuffModifiers.SPEED, Float.valueOf(1.0f), Integer.MAX_VALUE);
        buff.setModifier(BuffModifiers.WATER_WALKING, true);
    }

    @Override
    public void clientTick(ActiveBuff buff) {
        super.clientTick(buff);
        Mob owner = buff.owner;
        int minHeight = 14;
        int maxHeight = 16;
        final boolean reversed = GameRandom.globalRandom.nextBoolean();
        final float height = GameMath.lerp(GameRandom.globalRandom.nextFloat(), minHeight, maxHeight);
        final AtomicReference<Float> currentAngle = new AtomicReference<Float>(Float.valueOf(GameRandom.globalRandom.nextFloat() * 360.0f));
        float distance = 20.0f;
        owner.getLevel().entityManager.addParticle(owner.x + GameMath.sin(currentAngle.get().floatValue()) * distance, owner.y + GameMath.cos(currentAngle.get().floatValue()) * distance * 0.75f, Particle.GType.IMPORTANT_COSMETIC).colorRandom(310.0f, 0.95f, 0.95f, 10.0f, 0.05f, 0.05f).minDrawLight(150).moves((pos, delta, lifeTime, timeAlive, lifePercent) -> {
            float angle = currentAngle.accumulateAndGet(Float.valueOf(delta * 150.0f / 250.0f), Float::sum).floatValue();
            pos.x = owner.x + GameMath.sin(angle) * 70.0f;
            pos.y = owner.y + (reversed ? -GameMath.cos(angle) : GameMath.cos(angle)) * 70.0f * 0.9f;
        }).height(new ParticleOption.HeightGetter(){

            @Override
            public float tick(float delta, int lifeTime, int timeAlive, float lifePercent) {
                Float angle = (Float)currentAngle.get();
                float offset = GameMath.sin(angle.floatValue()) * 35.0f;
                return height + (reversed ? -offset : offset);
            }
        }).sizeFades(16, 20).lifeTime(2000);
        minHeight = -10;
        maxHeight = 0;
        float height2 = GameMath.lerp(GameRandom.globalRandom.nextFloat(), minHeight, maxHeight);
        owner.getLevel().entityManager.addParticle(owner.x + GameRandom.globalRandom.getFloatBetween(-10.0f, 10.0f), owner.y + GameRandom.globalRandom.getFloatBetween(-10.0f, 10.0f), Particle.GType.IMPORTANT_COSMETIC).colorRandom(310.0f, 0.95f, 0.95f, 10.0f, 0.05f, 0.05f).minDrawLight(150).movesFriction(owner.dx + GameRandom.globalRandom.getFloatBetween(-20.0f, 20.0f), owner.dy + GameRandom.globalRandom.getFloatBetween(-20.0f, 20.0f), 0.8f).heightMoves(height2, height2 - 30.0f).sizeFades(10, 16).lifeTime(1000);
    }

    @Override
    public void tickMovement(ActiveBuff buff, float delta) {
        float hoverHeight = buff.getGndData().getFloat("hoverHeight");
        hoverHeight += 0.04f * delta;
        hoverHeight = Math.min(hoverHeight, 10.0f);
        buff.getGndData().setFloat("hoverHeight", hoverHeight);
        Mob owner = buff.owner;
        if (owner.isClient() && (owner.dx != 0.0f || owner.dy != 0.0f)) {
            float speed = owner.getCurrentSpeed() * delta / 250.0f;
            GNDItemMap gndData = buff.getGndData();
            float soundBuffer = gndData.getFloat("soundBuffer") + Math.min(speed, 80.0f * delta / 250.0f);
            if (soundBuffer >= 55.0f) {
                soundBuffer -= 55.0f;
                SoundManager.playSound(GameResources.hoverboots, (SoundEffect)SoundEffect.effect(owner).pitch(1.0f));
            }
            gndData.setFloat("soundBuffer", soundBuffer);
        }
        if (!this.isBuffStillValid(buff)) {
            buff.remove();
        }
    }

    public boolean isBuffStillValid(ActiveBuff ab) {
        Mob owner = ab.owner;
        if (owner.isRiding()) {
            return false;
        }
        if (!owner.isPlayer) {
            return false;
        }
        PlayerMob player = (PlayerMob)owner;
        InventoryItem mountItem = player.getInv().equipment.getSelectedEquipmentSlot(0).getItem();
        if (mountItem == null) {
            return false;
        }
        return mountItem.item.getStringID().equals("ringofascension");
    }

    @Override
    public void addHumanDraw(ActiveBuff buff, HumanDrawOptions drawOptions) {
        int dir = buff.owner.getDir();
        drawOptions.sprite(new Point(0, dir % 4));
        drawOptions.addDrawOffset(0, (int)(-buff.getGndData().getFloat("hoverHeight")));
        float rotate = buff.owner.dx;
        drawOptions.rotate(Math.min(rotate / 40.0f, 5.0f), 32, 55);
    }
}

