/*
 * Decompiled with CFR 0.152.
 */
package necesse.entity.levelEvent.explosionEvent;

import java.awt.Color;
import java.awt.geom.Point2D;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.levelEvent.WaitForSecondsEvent;
import necesse.entity.levelEvent.explosionEvent.ExplosionEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;

public class MobsExplodeUpgradeShardsPerkExplosionLevelEvent
extends ExplosionEvent
implements Attacker {
    protected ParticleTypeSwitcher explosionTypeSwitcher = new ParticleTypeSwitcher(Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC, Particle.GType.CRITICAL);

    public MobsExplodeUpgradeShardsPerkExplosionLevelEvent() {
        this(0.0f, 0.0f, 100, new GameDamage(100.0f), false, 0.0f, null);
    }

    public MobsExplodeUpgradeShardsPerkExplosionLevelEvent(float x, float y, int range, GameDamage damage, boolean destructive, float toolTier, Mob owner) {
        super(x, y, range, damage, destructive, toolTier, owner);
        this.knockback = 0;
    }

    @Override
    protected GameDamage getTotalObjectDamage(float targetDistance) {
        return super.getTotalObjectDamage(targetDistance).modDamage(10.0f);
    }

    @Override
    protected boolean canHitMob(Mob target) {
        return false;
    }

    @Override
    protected void playExplosionEffects() {
        SoundManager.playSound(GameResources.magicExplosion, (SoundEffect)SoundEffect.effect(this.x, this.y).volume(1.0f).pitch(GameRandom.globalRandom.getFloatBetween(0.9f, 1.1f)));
        this.level.entityManager.events.addHidden(new WaitForSecondsEvent(0.2f){

            @Override
            public void onWaitOver() {
                SoundManager.playSound(GameResources.magicExplosion, (SoundEffect)SoundEffect.effect(MobsExplodeUpgradeShardsPerkExplosionLevelEvent.this.x, MobsExplodeUpgradeShardsPerkExplosionLevelEvent.this.y).volume(0.85f).pitch(GameRandom.globalRandom.getFloatBetween(1.2f, 1.4f)));
                this.level.entityManager.events.addHidden(new WaitForSecondsEvent(0.2f){

                    @Override
                    public void onWaitOver() {
                        SoundManager.playSound(GameResources.magicExplosion, (SoundEffect)SoundEffect.effect(MobsExplodeUpgradeShardsPerkExplosionLevelEvent.this.x, MobsExplodeUpgradeShardsPerkExplosionLevelEvent.this.y).volume(0.75f).pitch(GameRandom.globalRandom.getFloatBetween(1.4f, 1.6f)));
                    }
                });
            }
        });
    }

    @Override
    public float getParticleCount(float currentRange, float lastRange) {
        return super.getParticleCount(currentRange, lastRange) * 1.5f;
    }

    @Override
    protected float getDistanceMod(float targetDistance) {
        return 1.0f;
    }

    @Override
    public void spawnExplosionParticle(float x, float y, float dirX, float dirY, int lifeTime, float range) {
        if (GameRandom.globalRandom.getChance(0.5f)) {
            this.level.entityManager.addParticle(x + 4.0f, y - 10.0f, this.explosionTypeSwitcher.next()).color(new Color(16, 120, 255, 215)).movesConstant(dirX * 0.25f, dirY * 0.25f).height(10.0f).givesLight(75.0f, 0.5f).heightMoves(0.0f, 20.0f).onProgress(0.05f, p -> {
                Point2D.Float norm = GameMath.normalize(dirX, dirY);
                this.level.entityManager.addParticle(p.x + norm.x * 15.0f, p.y + norm.y * 15.0f, Particle.GType.IMPORTANT_COSMETIC).rotates().height(10.0f).color(new Color(16, 183, 255, 226)).movesConstant(dirX * 0.25f, dirY * 0.25f).heightMoves(0.0f, 20.0f).onProgress(0.1f, p2 -> {
                    Point2D.Float norm2 = GameMath.normalize(dirX, dirY);
                    this.level.entityManager.addParticle(p2.x + norm2.x * 20.0f, p2.y + norm2.y * 20.0f, Particle.GType.IMPORTANT_COSMETIC).rotates().sprite(GameResources.bubbleParticle.sprite(0, 0, 12)).height(10.0f).color(new Color(90, 195, 253, 226)).movesConstant(dirX * 0.25f, dirY * 0.25f).heightMoves(0.0f, 20.0f).lifeTime(2000);
                }).lifeTime(2000);
            }).lifeTime(2000);
        }
    }
}

